/*
 * Decompiled with CFR 0.152.
 */
package tschipp.callablehorses.common.worlddata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class StoredHorsesWorldData
extends WorldSavedData {
    private static String name = "callablehorses_stored_horses";
    private Map<String, Integer> entries = new HashMap<String, Integer>();
    private List<String> killedHorses = new ArrayList<String>();
    private List<String> disbandedHorses = new ArrayList<String>();
    private Map<String, CompoundNBT> offlineSavedHorses = new HashMap<String, CompoundNBT>();
    private int i = 0;

    public StoredHorsesWorldData() {
        super(name);
    }

    public StoredHorsesWorldData(String name) {
        super(name);
    }

    public void func_76184_a(CompoundNBT nbt) {
        int i = 0;
        while (nbt.func_74764_b("" + i)) {
            CompoundNBT subTag = nbt.func_74775_l("" + i);
            String storageID = subTag.func_74779_i("id");
            int num = subTag.func_74762_e("num");
            this.entries.put(storageID, num);
            ++i;
        }
        i = 0;
        CompoundNBT killed = nbt.func_74775_l("killed");
        while (killed.func_74764_b("" + i)) {
            this.killedHorses.add(killed.func_74775_l("" + i).func_74779_i("id"));
            ++i;
        }
        i = 0;
        CompoundNBT disbanded = nbt.func_74775_l("disbanded");
        while (disbanded.func_74764_b("" + i)) {
            this.disbandedHorses.add(disbanded.func_74775_l("" + i).func_74779_i("id"));
            ++i;
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        CompoundNBT tag = new CompoundNBT();
        this.entries.forEach((storageID, num) -> {
            CompoundNBT subTag = new CompoundNBT();
            subTag.func_74778_a("id", storageID);
            subTag.func_74768_a("num", num.intValue());
            tag.func_218657_a("" + this.i, (INBT)subTag);
            ++this.i;
        });
        this.i = 0;
        CompoundNBT killed = new CompoundNBT();
        for (int k = 0; k < this.killedHorses.size(); ++k) {
            CompoundNBT subTag = new CompoundNBT();
            subTag.func_74778_a("id", this.killedHorses.get(k));
            killed.func_218657_a("" + k, (INBT)subTag);
        }
        tag.func_218657_a("killed", (INBT)killed);
        CompoundNBT disbanded = new CompoundNBT();
        for (int k = 0; k < this.disbandedHorses.size(); ++k) {
            CompoundNBT subTag = new CompoundNBT();
            subTag.func_74778_a("id", this.disbandedHorses.get(k));
            disbanded.func_218657_a("" + k, (INBT)subTag);
        }
        tag.func_218657_a("disbanded", (INBT)disbanded);
        return tag;
    }

    public void addHorseNum(String id, int num) {
        this.entries.put(id, num);
        this.func_76185_a();
    }

    public int getHorseNum(String id) {
        Integer i = this.entries.get(id);
        if (i == null) {
            return 0;
        }
        return i;
    }

    public void disbandHorse(String id) {
        this.disbandedHorses.add(id);
        this.func_76185_a();
    }

    public boolean isDisbanded(String id) {
        return this.disbandedHorses.contains(id);
    }

    public void clearDisbanded(String id) {
        this.disbandedHorses.remove(id);
        this.func_76185_a();
    }

    public void markKilled(String id) {
        this.killedHorses.add(id);
        this.func_76185_a();
    }

    public boolean wasKilled(String id) {
        return this.killedHorses.contains(id);
    }

    public void clearKilled(String id) {
        this.killedHorses.remove(id);
        this.func_76185_a();
    }

    public void addOfflineSavedHorse(String id, CompoundNBT nbt) {
        this.offlineSavedHorses.put(id, nbt);
        this.func_76185_a();
    }

    public boolean wasOfflineSaved(String id) {
        return this.offlineSavedHorses.containsKey(id);
    }

    public CompoundNBT getOfflineSavedHorse(String id) {
        return this.offlineSavedHorses.get(id);
    }

    public void clearOfflineSavedHorse(String id) {
        this.offlineSavedHorses.remove(id);
        this.func_76185_a();
    }

    public static StoredHorsesWorldData getInstance(ServerWorld world) {
        DimensionSavedDataManager storage = world.func_217481_x();
        StoredHorsesWorldData instance = (StoredHorsesWorldData)storage.func_215752_a(StoredHorsesWorldData::new, name);
        storage.func_215757_a((WorldSavedData)instance);
        return instance;
    }
}

